#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

const double PI = acos(-1.0);

struct Vektor {
    double ugao;
    double x;
    double y;
    int indeks;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Vektor> vektori(n);

    for(int i = 0; i < n; i++){
        double x, y;
        cin >> x >> y;

        double ugao = atan2(y, x);
        if(ugao < 0.0){
            ugao += 2.0 * PI;
        }

        vektori[i].ugao = ugao;
        vektori[i].x = x;
        vektori[i].y = y;
        vektori[i].indeks = i;
    }

    sort(vektori.begin(), vektori.end(), [](const Vektor &a, const Vektor &b){
        return a.ugao < b.ugao;
    });

    //dupliramo da bi bilo lakse
    vector<Vektor> prosireni(2 * n);
    for(int i = 0; i < n; i++){
        prosireni[i] = vektori[i];
        prosireni[i + n] = vektori[i];
        prosireni[i + n].ugao += 2.0 * PI;
    }

    double najboljaDuzina2 = 0.0;
    int najboljiLevi = 0, najboljiDesni = 0;

    double zbirX = 0.0, zbirY = 0.0;
    int desni = 0;
    
    //prvi prolaz
    for(int levi = 0; levi < n; levi++){
        while(desni < levi + n and prosireni[desni].ugao - prosireni[levi].ugao < PI){
            zbirX += prosireni[desni].x;
            zbirY += prosireni[desni].y;
            desni++;
        }

        double duzina2 = zbirX * zbirX + zbirY * zbirY;
        if(duzina2 > najboljaDuzina2){
            najboljaDuzina2 = duzina2;
            najboljiLevi = levi;
            najboljiDesni = desni;
        }

        zbirX -= prosireni[levi].x;
        zbirY -= prosireni[levi].y;
    }

    // drugi prolaz - suprotan smer
    /*zbirX = 0.0;
    zbirY = 0.0;
    desni = 2 * n - 1;

    for(int levi = 2 * n - 1; levi >= n; levi--){
        while(desni > levi - n and prosireni[levi].ugao - prosireni[desni].ugao < PI){
            zbirX += prosireni[desni].x;
            zbirY += prosireni[desni].y;
            desni--;
        }

        int levi0 = desni + 1;
        int desni0 = levi + 1;

        double duzina2 = zbirX * zbirX + zbirY * zbirY;
        if(duzina2 > najboljaDuzina2){
            najboljaDuzina2 = duzina2;
            najboljiLevi = levi0;
            najboljiDesni = desni0;
        }

        zbirX -= prosireni[levi].x;
        zbirY -= prosireni[levi].y;
    }*/



    //pokusamo da unapredimo samo najbolji
    double sumaX = 0.0, sumaY = 0.0;
    
    for(int i = najboljiLevi; i < najboljiDesni; i++){
        sumaX += prosireni[i].x;
        sumaY += prosireni[i].y;
    }
    double osnovnaDuzina2 = najboljaDuzina2;

    double novaNajboljaDuzina2 = osnovnaDuzina2;
    int noviLevi = najboljiLevi;
    int noviDesni = najboljiDesni;

    //brisemo sa leve strane
    {
        double tx = sumaX, ty = sumaY;
        int leviTrenutni = najboljiLevi;
        
        while(leviTrenutni < najboljiDesni){
            tx -= prosireni[leviTrenutni].x;
            ty -= prosireni[leviTrenutni].y;
            
            leviTrenutni++;
            double duzina2 = tx * tx + ty * ty;
            
            if(duzina2 > novaNajboljaDuzina2){
                novaNajboljaDuzina2 = duzina2;
                noviLevi = leviTrenutni;
                noviDesni = najboljiDesni;
            } 
            else{
                break;
            }
        }
    }

    // brisemo sa desne
    {
        double tx = sumaX, ty = sumaY;
        int desniTrenutni = najboljiDesni - 1;
        
        while(desniTrenutni >= najboljiLevi){
            tx -= prosireni[desniTrenutni].x;
            ty -= prosireni[desniTrenutni].y;
            
            desniTrenutni--;
            double duzina2 = tx * tx + ty * ty;
            
            if(duzina2 >novaNajboljaDuzina2){
                novaNajboljaDuzina2 = duzina2;
                noviLevi = najboljiLevi;
                noviDesni = desniTrenutni + 1;
            } 
            else{
                break;
            }
        }
    }

    if(novaNajboljaDuzina2 > najboljaDuzina2){
        najboljaDuzina2 = novaNajboljaDuzina2;
        najboljiLevi = noviLevi;
        najboljiDesni = noviDesni;
    }


    vector<int> izabrani;
    for(int i = najboljiLevi; i < najboljiDesni; i++){
        izabrani.push_back(prosireni[i].indeks);
    }

    sort(izabrani.begin(), izabrani.end());

    cout << izabrani.size() << '\n';
    for(size_t i = 0; i < izabrani.size(); i++){
        cout << izabrani[i] + 1 << ' ';
    }
    return 0;
}